﻿Partial Public Class EasingFunctionDialog
    Inherits PhoneApplicationPage

    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property EasingFunction() As EasingFunctionBase


    Private Sub OnRadioButtonChecked(ByVal sender As Object, ByVal args As RoutedEventArgs)
        Dim _type = TryCast((TryCast(sender, RadioButton)).Tag, Type)

        If _type Is Nothing Then
            EasingFunction = Nothing
        Else
            Dim constructor = _type.GetConstructor(Type.EmptyTypes)
            EasingFunction = TryCast(constructor.Invoke(Nothing), EasingFunctionBase)
        End If
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        ' Create "None" RadioButton
        Dim radio As New RadioButton()
        radio.Content = "None"
        radio.IsChecked = (EasingFunction Is Nothing)
        AddHandler radio.Checked, AddressOf OnRadioButtonChecked
        stack.Children.Add(radio)

        Dim [assembly] =
            System.Reflection.Assembly.Load("System.Windows")

        ' Create RadioButton for each easing function
        For Each _type In [assembly].GetTypes()
            If _type.IsPublic AndAlso _type.IsSubclassOf(GetType(EasingFunctionBase)) Then
                radio = New RadioButton()
                radio.Content = _type.Name
                radio.Tag = _type
                radio.IsChecked = (EasingFunction IsNot Nothing AndAlso
                                   EasingFunction.GetType() Is _type)
                AddHandler radio.Checked, AddressOf OnRadioButtonChecked
                stack.Children.Add(radio)
            End If
        Next _type

        MyBase.OnNavigatedTo(args)
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        If TypeOf args.Content Is MainPage Then
            TryCast(args.Content, MainPage).EasingFunction = EasingFunction
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub
End Class
